import tkinter as tk
import tkinter.scrolledtext as tkst

def create_window(title, size='1000x500'):

    root = tk.Tk()
    root.title(title)
    root.geometry(size)

    return root


def create_frames(container):

    left_frame = tk.Frame(container)
    left_frame.pack(side=tk.LEFT, padx=50)
    
    right_frame = tk.Frame(container)
    right_frame.pack(side=tk.RIGHT, padx=50)
 
    control_box = tk.Frame(left_frame)
    control_box.pack(side=tk.TOP, pady=10)

    return control_box, right_frame


def digitizing_control(container):

    lbl_1 = tk.Label(container,
                     text='Digitizing Parameters')
    lbl_1.pack()

    frame = tk.Frame(container, bg='blue', bd=2)
    frame.pack()

    lbl_2 = tk.Label(frame, text='Number of Points')
    lbl_2.pack(fill=tk.X)

    var_num = tk.StringVar()
    ent_1 = tk.Entry(frame, textvariable=var_num,
                     justify=tk.CENTER)
    ent_1.pack(fill=tk.X)

    lbl_3 = tk.Label(frame, text='Sampling Frequency (Hz)')
    lbl_3.pack(fill=tk.X)

    var_samp_freq = tk.StringVar()
    ent_2 = tk.Entry(frame, textvariable=var_samp_freq,
                      justify=tk.CENTER)
    ent_2.pack(fill=tk.X)

    return var_num, var_samp_freq


def waveform_control(container):

    lbl_1 = tk.Label(container, text='Waveform Parameters')
    lbl_1.pack()

    frame = tk.Frame(container, bg='blue', bd=2)
    frame.pack()

    lbl_2 = tk.Label(frame, text='Amplitude')
    lbl_2.pack(fill=tk.X)

    var_a = tk.StringVar()
    ent_1 = tk.Entry(frame, textvariable=var_a,
                     justify=tk.CENTER)
    ent_1.pack(fill=tk.X)

    lbl_3 = tk.Label(frame, text='Frequency (Hz)')
    lbl_3.pack(fill=tk.X)

    var_f = tk.StringVar()
    ent_2 = tk.Entry(frame, textvariable=var_f,
                     justify=tk.CENTER)
    ent_2.pack(fill=tk.X)

    lbl_4 = tk.Label(frame, text='Shape')
    lbl_4.pack(fill=tk.X)

    var_shape = tk.StringVar()
    options = ['Sine', 'Cosine', 'DC Level', 'Square', 
               'Sawtooth', 'Triangle', 'User-Defined']
    opm = tk.OptionMenu(frame, var_shape, *options)
    opm.pack(fill=tk.X)

    return var_a, var_f, var_shape


def action_button(container, label, action):
    
    frame = tk.Frame(container)
    frame.pack(pady=8)
    
    btn = tk.Button(frame, text=label, command=action)
    btn.pack()

    return btn


def get_dig_entries(var_num, var_samp_freq):

    num = int(var_num.get())
    samp_freq = float(var_samp_freq.get())

    return num,samp_freq


def get_wav_entries(var_a, var_f, var_shape):

    shape = var_shape.get()
    if shape == 'User-Defined':
        a = 0
        f = 0
    elif shape == 'DC Level':
        a = float(var_a.get())
        f = 0
    else:
        a = float(var_a.get())
        f = float(var_f.get())
    
    return a, f, shape


def print_entries():

    num, samp_freq = get_dig_entries(var_num,
                                     var_samp_freq)
    a, f, shape = get_wav_entries(var_a, var_f, var_shape)
    print(num, samp_freq)
    print(a, f, shape)

    return


def create_indicator(container, label_1,
                     label_2='', char_width=20):

    lbl_1 = tk.Label(container, text=label_1)
    lbl_1.pack()

    frame = tk.Frame(container, bg='blue', bd=2)
    frame.pack()

    lbl_2 = tk.Label(frame, text=label_2, width=char_width)
    lbl_2.pack(fill=tk.X)

    return lbl_2


def trigger_control(container):

    lbl = tk.Label(container, text='Digital Trigger Edge')
    lbl.pack(fill=tk.X)
       
    frame = tk.Frame(container, bg='blue', bd=2)
    frame.pack()

    var_trig = tk.StringVar()
    options = ['Falling', 'Rising']
    opm = tk.OptionMenu(frame, var_trig, *options)
    opm.config(width=8)
    opm.pack(fill=tk.X)

    return var_trig


def get_edge_option(var_trig):

    edge_option = var_trig.get()

    return edge_option


def create_control(container, label, char_width=20):

    lbl = tk.Label(container, text=label)
    lbl.pack()

    frame = tk.Frame(container, bg='blue', bd=2)
    frame.pack()

    var_ent = tk.StringVar()
    ent = tk.Entry(frame, textvariable=var_ent,
                   justify=tk.CENTER, width=char_width)
    ent.pack(fill=tk.X)

    return var_ent


def get_control_string(var_ent):

    control_string = var_ent.get()

    return control_string


def window_control(container):

    lbl_1 = tk.Label(container,text='Window Menu')
    lbl_1.pack()

    frame = tk.Frame(container, bg='blue', bd=2)
    frame.pack()
    
    var_window = tk.StringVar()
    options = ['Rectangle', 'Hann', 'Hamming', 'Flattop',
               'Blackman']
    opm = tk.OptionMenu(frame, var_window, *options)
    opm.pack(fill=tk.X)

    return var_window


def get_window_option(var_window):

    win_type = var_window.get()

    return win_type


def create_text_box(container, label,
                    char_width=60, lines=20):

    lbl = tk.Label(container, text=label)
    lbl.pack()

    frame = tk.Frame(container, bg='blue', bd=2)
    frame.pack()

    stx = tkst.ScrolledText(frame, width=char_width,
                            height=lines)
    stx.pack(fill=tk.X)
    
    return stx


def create_dmm_control(container):

    char = 20

    lbl = tk.Label(container, 
                   text='Measurement Parameters')
    lbl.pack()

    frame = tk.Frame(container, bg='blue', bd=2)
    frame.config(width=char)
    frame.pack()
    
    
    lbl_0 = tk.Label(frame, 
                     text='Measurement Function')
    lbl_0.pack(fill=tk.X)
    var_0 = tk.StringVar()
    options_0 = ['DC Voltage', 'DC Current', 
                 'Resistance']
    opm_0 = tk.OptionMenu(frame, var_0, *options_0)
    opm_0.config(width=char)
    opm_0.pack(fill=tk.X)

    lbl_1 = tk.Label(frame, text='Voltage Range')
    lbl_1.pack(fill=tk.X)
    var_1 = tk.StringVar()
    options_1 = ['100 mV', '1 V', '10 V', 
                 '100 V', '1000 V']
    opm_1 = tk.OptionMenu(frame, var_1, *options_1)
    opm_1.config(width=char)
    opm_1.pack(fill=tk.X)

    lbl_2 = tk.Label(frame, text='Current Range')
    lbl_2.pack(fill=tk.X)
    var_2 = tk.StringVar()
    options_2 = ['0.1 mA', '1 mA', '10 mA', '100 mA',
                 '1 A', '3 A']
    opm_2 = tk.OptionMenu(frame, var_2, *options_2)
    opm_2.config(width=char)
    opm_2.pack(fill=tk.X)

    lbl_3 = tk.Label(frame, text='Resistance Range')
    lbl_3.pack(fill=tk.X)
    var_3 = tk.StringVar()
    options_3 = ['100 ohm', '1 kohm', '10 kohm',
                '100 kohm', '1 Mohm', '10 Mohm', 
                '100 Mohm']
    opm_3 = tk.OptionMenu(frame, var_3, *options_3)
    opm_3.config(width=char)
    opm_3.pack(fill=tk.X)


    lbl_4 = tk.Label(frame, 
                     text='Fractional Resolution')
    lbl_4.pack(fill=tk.X)
    var_4 = tk.StringVar()
    options_4 = ['3 ppm (0.02 NPLC)',
                 '0.7 ppm (0.2 NPLC)',
                 '0.3 ppm (1 NPLC)',
                 '0.1 ppm (10 NPLC)',
                 '0.03 ppm (100 NPLC)']
    opm_4 = tk.OptionMenu(frame, var_4, *options_4)
    opm_4.config(width=char)
    opm_4.pack(fill=tk.X)

    lbl_5 = tk.Label(frame, text='Auto Zero')
    lbl_5.pack(fill=tk.X)
    var_5 = tk.StringVar()
    options_5 = ['On', 'Off']
    opm_5 = tk.OptionMenu(frame, var_5, *options_5)
    opm_5.config(width=char)
    opm_5.pack(fill=tk.X)

    lbl_6 = tk.Label(frame, text='Sample Count')
    lbl_6.pack(fill=tk.X)
    var_6 = tk.StringVar()
    ent = tk.Entry(frame, textvariable=var_6)
    ent.config(width=char, justify=tk.CENTER)
    ent.pack(fill=tk.X)

    var_list = [var_0, var_1, var_2, var_3, var_4, 
                var_5, var_6]

    return var_list


def get_dmm_control_args(var_list):

    measurement = var_list[0].get()

    if measurement == 'DC Voltage':
        measurement_key = 'dc_voltage'
        range_key = var_list[1].get()
    elif measurement == 'DC Current':
        measurement_key = 'dc_current'
        range_key = var_list[2].get()
    elif measurement == 'Resistance':
        measurement_key = 'resistance'
        range_key = var_list[3].get()

    resfrac_key = var_list[4].get()
    zero_key = var_list[5].get()
    sampcount_int = int(var_list[6].get())

    args = (measurement_key, range_key, resfrac_key,
           zero_key, sampcount_int)

    return args
